/*
prep.c
11-6-91 dbdavis

(c) copyright 1991, 1992, 1993 Ameritec Corporation

convert script text file to Intel hex records.

$Log:	prep.c $
 * Revision 2.3  93/12/03  13:42:06  david
 * eat empty lines, error on all blank lines.
 * 
 * Revision 2.2  93/03/01  14:37:08  david
 * fixed command line. Limit line length, strip trailing comments ';' or '/*'
 * 
 * Revision 2.1  93/02/24  15:29:44  david
 * beta release
 * 
 * Revision 2.0  93/01/18  15:24:39  david
 * initial release
 * 
*/

#include "sys/types.h"
#include "sys/stat.h"
#include "stdio.h"

#define MAXLINE 1024

void main(argc, argv)
int argc;
char **argv;
{
    FILE *fp,*fp1;
    char fname[16];
    char sname[16];
    char lbuf[80];
    unsigned short i,tsum,addr,uLineLen,uLineNumber = 0;
    int ch, next_ch, err;
    int tnum;
    unsigned char sum,endfile,allblank,*p;
    struct stat fp_stat;
    struct
    {
        char type;
	char name[12];
	char number;
	struct
	{
	    char lsb;
	    char msb;
	} size;
    } header;

    if (argc < 2)
    {
        printf("PREP script file preparation utility Version 2.05\n");
        printf("usage: prep <\"scriptname\" | -n> <source> [number]\n");
	printf("    where the optional \"scriptname\" allows you to specify the script name\n");
	printf("(the quotes are required only if the script name includes spaces). The -n\n");
        printf("option must be specified if the name is to be taken from the script text.\n");
        printf("( not currently supported by AM2 )\n");
	printf("The <source> is the filename of the script source, without the '.src'\n");
	printf("extension, and the script number is optional.\n");
	exit(1);
    }
    
    header.number = 0;
    header.name[0] = 0;

    /* get command line options */
    if (( argc == 4) && (tnum = atoi(argv[3])) != 0)
    {
	if (tnum > 20)
	{
	    printf("Script number must be 1-20\n");
	    exit(1);
	}
	header.number = tnum;
#ifdef DEBUG
	printf("Number from command line: %hu\n",
	    (unsigned short)header.number);
#endif
    }

    if (strncmp("-n",argv[1],2))
	strncpy(header.name, argv[1], 12);

    sprintf(fname,"%s.src",argv[2]);
    sprintf(sname,"%s.hex",argv[2]);

    fp1 = fopen(sname,"w");
    if (!fp1)
    {
        printf("prep: can't open output file\n\n",sname);
        exit(2);
    }

    fp = fopen(fname,"rb");
    if (!fp)
    {
        printf("prep: can't open input file %s\n\n",fname);
        exit(2);
    }
    addr = 0;


    /* set up header */
    header.type = 3;
    if ( (err = stat(fname,&fp_stat)) != 0 )
    {
        printf("stat() returns err %d\n",err);
	exit(3);
    }

    i = (unsigned short)fp_stat.st_size;
    header.size.lsb = i & 0xff;
    header.size.msb = (i >> 8) & 0xff;
#ifdef DEBUG
    printf("input file size: %hu\n",i);
#endif
    /* write ':' and len = 16 */
    sprintf(lbuf,":10");

    /* write address and type */
    sprintf(&lbuf[3],"%4.4X00",addr);
    addr += 16;

    /* header bytes */
    p = (unsigned char*)&header;
    for ( i = 9; i < 40; i += 2 )
    {
	sprintf(&lbuf[i],"%2.2X",*p++);
    }

    /* now calculate the checksum */
    for (i = 1, sum = 0; i < 40; i += 2)
    {
	sscanf(&lbuf[i],"%2hx",&tsum);
	sum += tsum;
    }
    sprintf(lbuf+i,"%2.2X\n",(256 - sum) & 0xff);

    /* write the line to the hex file */
    fprintf(fp1,lbuf);

    uLineLen = 0;
    next_ch = getc(fp);
    next_ch &= 0xff;

    for (;;)
    {
#ifdef DEBUG
	printf("write hex record\n");
#endif

	/* write ':' and len = 16 */
	sprintf(lbuf,":10");

	/* write address and type */
	sprintf(&lbuf[3],"%4.4X00",addr);
	addr += 16;

	/* read 16 bytes */
	endfile = 1;
	for ( i = 9; i < 40; i += 2, uLineLen++ )
	{
	    ch = next_ch;
	    next_ch = getc(fp);
	    next_ch &= 0xff;

	    if ((uLineLen > MAXLINE)
	        || ( ch == ';')
		|| (( ch == '/') && (next_ch == '*')))
	    {
	        while ((ch = next_ch) != (EOF & 0xff) )
		{
		    next_ch = getc(fp);
		    next_ch &= 0xff;
		    if ( (ch == '\n') || (ch == '\r') ) /* EOL? */
			break;
		}
	    }

	    if ((ch == '\n') || (ch == '\r'))   /* EOL? */
	    {
		uLineNumber++;
		if (allblank)
		{
		    printf("Error - all blank line at %u\n", uLineNumber );
		    fclose(fp);
		    fclose(fp1);
		    exit(1);
		}
		allblank = 1;
		/* eat the CRLF, use the LF */
		ch = '\n';
		while (  ( next_ch == '\n')
		      || ( next_ch == '\r') )   /* eat 'em */
		{
		    next_ch = getc(fp);
		    next_ch &= 0xff;
		    if ( next_ch == '\n' )
			uLineNumber++;
		}
		uLineLen = 0;
	    }
	    else if (ch != ' ')
		allblank = 0;


	    if (ch != (EOF & 0xff) )
		endfile = 0;
	    else
	    {
		ch = 0;
	    }

	    sprintf(&lbuf[i],"%2.2X",ch);
	}

	/* now calculate the checksum */
	for (i = 1, sum = 0; i < 40; i += 2)
	{
	    sscanf(&lbuf[i],"%2hx",&tsum);
	    sum += tsum;
	}
	sprintf(lbuf+i,"%2.2X\n",(256 - sum) & 0xff);

	/* write the line to the hex file */
	fprintf(fp1,lbuf);

#ifdef DEBUG
	printf(lbuf);
#endif
	if (endfile)
	    break;

    }
#ifdef DEBUG
    printf("write end-of-file record\n");
#endif
    /* write end-of-file record */
	fprintf(fp1,":00000001FF\n\r");
    fclose(fp);
    fclose(fp1);
    exit(0);
}
/* end of prep.c */
